#pragma	once

class CException {
public:
	CException(const tstring& aMessage) { message = aMessage; }
	virtual ~CException() {}

	const tstring& getMessage() const { return message; }

protected:
	tstring	message;
};


class CIOException:public CException {
public:
	CIOException(const tstring& aMessage) : CException(aMessage) {}
};


class CActionException:public CException {
public:
	CActionException(const tstring& aMessage) : CException(aMessage) {}
};


class CRuntimeException : public CException {
public:
	CRuntimeException(const tstring& aMessage) : CException(aMessage) {}
};


class CBadConfigException : public CException {
public:
	CBadConfigException(const tstring& aMessage) : CException(aMessage) {}
};


class CLogicException : public CException {
public:
	CLogicException(const tstring& aMessage) : CException(aMessage) {}
};
